
  NAME OsCalls

$NOLIST

RAM_CGROUP GROUP RAM_CODE


NULLBYTE EQU 0FFh
myRomID EQU 0


PUBLIC myRomID
PUBLIC OsIntrEntry
PUBLIC mySlot
PUBLIC SetRomSlot

EXTRN CpAllocate: FAR        ; OsAllocate : FAR
EXTRN OsFree : FAR
EXTRN CpGetSize: FAR         ; OsGetSize : FAR
EXTRN CpGetMemStatus: FAR    ; OsGetMemStatus : FAR
EXTRN xOsCreateProcess : FAR
EXTRN OsForkProcess : FAR
EXTRN CpDelay: FAR           ; OsDelay : FAR
EXTRN OsSetPriority : FAR
;EXTRN OsWhoAmI : FAR
EXTRN CpWhoAmI: FAR          ; OsWhereAmI : FAR
EXTRN OsDeleteProcess : FAR
EXTRN OsExit : FAR
EXTRN CpReceive: FAR         ; OsReceive : FAR
EXTRN OsSend : FAR
EXTRN OsCreateSemaphore : FAR
EXTRN CpWait: FAR            ; OsWait : FAR
EXTRN CpSignal: FAR          ; OsSignal : FAR
EXTRN CpDeleteSemaphore: FAR ; OsDeleteSemaphore : FAR
EXTRN xOsAttach : FAR
EXTRN xOsOpen : FAR
EXTRN OsRead : FAR
EXTRN OsWrite : FAR
EXTRN OsSeek : FAR
EXTRN xOsTruncate : FAR
EXTRN xOsFlushAllBuffers : FAR
EXTRN xOsRename : FAR
EXTRN OsChangeExtension : FAR
EXTRN xOsClose : FAR
EXTRN xOsDelete : FAR
EXTRN xOsDetach : FAR
EXTRN OsGetStatus : FAR
EXTRN OsSetStatus : FAR
EXTRN xOsGetArgument : FAR
EXTRN xOsSwitchBuffer : FAR
EXTRN xOsOverlay : FAR
EXTRN xOsGetSystemID : FAR
EXTRN CpGetTime: FAR        ; OsGetTime : FAR
EXTRN OsRegisterName : FAR
EXTRN OsLookUpName : FAR
EXTRN xOsDecodeException : FAR
EXTRN OsHandleCancel : FAR
EXTRN xOsReadDescriptor : FAR
EXTRN xOsWriteDescriptor : FAR
EXTRN OsAddKbChar : FAR
EXTRN ConKeyPressed : FAR
EXTRN ConPeekChar : FAR
EXTRN ConCharIn : FAR
EXTRN ConCharOut : FAR
EXTRN ConLineOut : FAR
EXTRN ConDefCsr : FAR
EXTRN ConMoveCsr : FAR
EXTRN ConResetDisplay : FAR
EXTRN xOsAddDevice : FAR
EXTRN xOsRemoveDevice : FAR
EXTRN OsGetProperty : FAR
EXTRN xOsPutProperty : FAR
EXTRN xOsAddAlias : FAR
EXTRN xOsDeleteAlias : FAR
EXTRN OsUnLoad : FAR
EXTRN OsVersionNumber : FAR
EXTRN xGetEntryPoint : FAR
EXTRN GetConsoleState : FAR
EXTRN xWinFrameWindow : FAR
EXTRN xWinClipLine : FAR
EXTRN xWinClipRectangle : FAR
EXTRN xWinDrawLine : FAR
EXTRN xWinEraseLine : FAR
EXTRN xWinInvertLine : FAR
EXTRN xWinSetClip : FAR
EXTRN xWinResetClip : FAR
EXTRN xWinSetWindow : FAR
EXTRN xWinInitDefaultWindow : FAR
EXTRN xWinEraseRectangle : FAR
EXTRN xWinInvertRectangle : FAR
EXTRN xWinEraseWindow : FAR
EXTRN xWinDrawPixel : FAR
EXTRN xWinErasePixel : FAR
EXTRN xWinCopyRectangle : FAR
EXTRN xWinScrollRectangle : FAR
EXTRN xWinScrollWindow : FAR
EXTRN xWinDrawChar : FAR
EXTRN xWinDrawChars : FAR
EXTRN xWinInvertChar : FAR
EXTRN xWinEraseChar : FAR
EXTRN xWinGetWindowExtent : FAR
EXTRN xWinInvertPixel : FAR
EXTRN WinSetFont : FAR
EXTRN xWinTestPixel : FAR
EXTRN WinGetCurrentWindowState : FAR
EXTRN WinLoadFont : FAR
EXTRN OsCallDriver : FAR
EXTRN OsGetPrefix : FAR
EXTRN OsGetWork : FAR
EXTRN SysdepInvalidCall : FAR
EXTRN IntSend : FAR
EXTRN OsMatchWildCard : FAR
EXTRN ConHexOut : FAR
EXTRN OsOuroBouro : FAR
EXTRN WinHandlePhone : FAR
EXTRN LineHeight : FAR
EXTRN CharHeight : FAR
EXTRN CharWidth : FAR
EXTRN BaseLine : FAR
EXTRN xOsUpdateDeviceList : FAR
EXTRN WinAllocateWindowMemory : FAR
EXTRN xWinSetAlternateWindow : FAR
EXTRN xWinCopyRemoteRectangle : FAR
EXTRN ConLineIn: FAR
EXTRN OsAddressOf: FAR
EXTRN CheckCodeEscape: FAR
EXTRN DqAllocate: FAR
EXTRN DqFree: FAR
EXTRN DqGetSize: FAR
EXTRN DqTrapCC: FAR
EXTRN DqTrapException: FAR
EXTRN DqGetExceptionHandler: FAR
EXTRN DqDecodeException: FAR
EXTRN DqGetSystemID: FAR
EXTRN DqGetTime: FAR
EXTRN DqDelete: FAR
EXTRN DqRename: FAR
EXTRN DqAttach: FAR
EXTRN DqCreate: FAR
EXTRN DqOpen: FAR
EXTRN DqSeek: FAR
EXTRN DqGetConnectionStatus: FAR
EXTRN DqChangeExtension: FAR
EXTRN DqOverlay: FAR
EXTRN DqSpecial: FAR
EXTRN DqGetArgument: FAR
EXTRN DqSwitchBuffer: FAR
EXTRN DqExit: FAR
EXTRN DqReserveIOMemory: FAR
EXTRN DqFileInfo: FAR
; EXTRN DqDecodeTime: FAR
; EXTRN DqChangeAccess: FAR
EXTRN RealBBDevice: FAR
EXTRN RealCiDevice: FAR
EXTRN RealCoDevice: FAR
EXTRN WinAddKBChar: FAR

EXTRN RedoListsPatch: FAR
EXTRN FindThisTitlePatch: FAR
$EJECT

RAM_CODE SEGMENT PUBLIC 'CODE'
  ASSUME CS:RAM_CGROUP, DS:NOTHING, ES:NOTHING


; SetRomSlot: PROCEDURE BYTE
;  This routine returns AL=FFH if the InteGRiD Rom is not there

SetRomSlot PROC FAR
  MOV  AL, 0FEh           ; not really used in this module
  MOV  CS:mySlot, AL
  MOV  AL, 0              ; RETURN (0), i.e. OK for non-ROM InteGRiD
  RET
SetRomSlot ENDP

; List of routines exported by the Os

routines DD CpAllocate         ; OsAllocate
         DD OsFree
         DD CpGetSize          ; OsGetSize
         DD CpGetMemStatus     ; OsGetMemStatus
         DD xOsCreateProcess
         DD OsForkProcess
         DD CpDelay            ; OsDelay
         DD OsSetPriority
         DD CpWhoAmI           ; OsWhoAmI
         DD CpWhoAmI           ; OsWhereAmI
         DD OsDeleteProcess
         DD OsExit
         DD CpReceive          ; OsReceive
         DD OsSend
         DD OsCreateSemaphore
         DD CpWait             ; OsWait
         DD CpSignal           ; OsSignal
         DD CpDeleteSemaphore  ; OsDeleteSemaphore
         DD xOsAttach
         DD xOsOpen
         DD OsRead
         DD OsWrite
         DD OsSeek
         DD xOsTruncate
         DD xOsFlushAllBuffers
         DD xOsRename
         DD OsChangeExtension
         DD xOsClose
         DD xOsDelete
         DD xOsDetach
         DD OsGetStatus
         DD OsSetStatus
         DD xOsGetArgument
         DD xOsSwitchBuffer
         DD xOsOverlay
         DD xOsGetSystemID
         DD CpGetTime         ; OsGetTime
         DD OsRegisterName
         DD OsLookUpName
         DD xOsDecodeException
         DD OsHandleCancel
         DD xOsReadDescriptor
         DD xOsWriteDescriptor
         DD OsAddKbChar
         DD ConKeyPressed
         DD ConPeekChar
         DD ConCharIn
         DD ConCharOut
         DD ConLineOut
         DD ConDefCsr
         DD ConMoveCsr
         DD ConResetDisplay
         DD xOsAddDevice
         DD xOsRemoveDevice
         DD OsGetProperty
         DD xOsPutProperty
         DD xOsAddAlias
         DD xOsDeleteAlias
         DD OsUnLoad
         DD OsVersionNumber
         DD xGetEntryPoint
         DD GetConsoleState
         DD xWinFrameWindow
         DD xWinClipLine
         DD xWinClipRectangle
         DD xWinDrawLine
         DD xWinEraseLine
         DD xWinInvertLine
         DD xWinSetClip
         DD xWinResetClip
         DD xWinSetWindow
         DD xWinInitDefaultWindow
         DD xWinEraseRectangle
         DD xWinInvertRectangle
         DD xWinEraseWindow
         DD xWinDrawPixel
         DD xWinErasePixel
         DD xWinCopyRectangle
         DD xWinScrollRectangle
         DD xWinScrollWindow
         DD xWinDrawChar
         DD xWinDrawChars
         DD xWinInvertChar
         DD xWinEraseChar
         DD xWinGetWindowExtent
         DD xWinInvertPixel
         DD WinSetFont
         DD xWinTestPixel
         DD WinGetCurrentWindowState
         DD WinLoadFont
         DD OsCallDriver
         DD OsGetPrefix
         DD OsGetWork
         DD IntSend
         DD SysdepInvalidCall    ;OsGetCardStatus
         DD SysdepInvalidCall    ;OsCreateRemoteProcess
         DD SysdepInvalidCall    ;OsLogError
         DD OsMatchWildCard 
         DD ConHexOut
         DD OsOuroBouro
         DD WinHandlePhone
         DD LineHeight
         DD CharHeight
         DD CharWidth
         DD BaseLine
         DD SysdepInvalidCall    ;ConDecimalOut
         DD xOsUpdateDeviceList
         DD WinAllocateWindowMemory
         DD xWinSetAlternateWindow
         DD xWinCopyRemoteRectangle
         DD ConLineIn
         DD OsAddressOf
        
         DD CheckCodeEscape        
         DD DqAllocate             ; 0
         DD DqFree                 ; 1
         DD DqGetSize              ; 2
         DD DqTrapCC               ; 3
         DD DqTrapException        ; 4
         DD DqGetExceptionHandler  ; 5
         DD DqDecodeException      ; 6
         DD DqGetSystemID          ; 7
         DD DqGetTime              ; 8
         DD DqDelete               ; 9
         DD DqRename               ; a
         DD DqAttach               ; b
         DD DqCreate               ; c
         DD DqOpen                 ; d
         DD xOsClose               ; e
         DD xOsDetach              ; f
         DD OsRead                 ; 10
         DD OsWrite                ; 11
         DD DqSeek                 ; 12
         DD xOsTruncate            ; 13
         DD DqGetConnectionStatus  ; 14
         DD DqChangeExtension      ; 15
         DD DqOverlay              ; 16
         DD DqSpecial              ; 17
         DD DqGetArgument          ; 18
         DD DqSwitchBuffer         ; 19
         DD DqExit                 ; 1a
         DD DqFileInfo             ; 1b
         DD DqReserveIOMemory      ; 1c
         DD DqFileInfo             ; DqDecodeTime 1d
         DD DqFileInfo             ; DqChangeAccess 1e

         DD RealBBDevice
         DD RealCiDevice
         DD RealCoDevice
         DD WinAddKBChar

         DD RedoListsPatch
         DD FindThisTitlePatch

mySlot   DB ?                    ; current Rom Slot
$EJECT

OsIntrEntry LABEL FAR
  JMP  SHORT InterruptEntry

IndrEntry:
  JMP  SHORT IndirectEntry

; info on jump table
jumpTable:
  DW   routines
  DW   0
parmTable:
  DW   0          ; this is no parm table
  DW   0
numCalls:
  DB   150        ; # calls in this interrupt

InterruptEntry:

  POP  BX          ; get IP
  POP  ES          ; get CS
  POPF             ; set flags

  MOV  AX, ES:[BX] ; get call #
  XOR  AH, AH
  INC  BX          ; skip call #

  PUSH ES          ; push CS
  PUSH BX          ; push IP

IndirectEntry:
  MOV  BX, AX      ; table index
  SHL  BX, 1
  SHL  BX, 1       ; bx = bx * 4


  LES  DI, DWORD PTR jumpTable  ; get the jump table
  MOV  AX, ES         ; get the segment part
  CMP  AX, 0          ; if seg = 0 THEN use CS
  JNZ  GoToIt
  MOV  AX, CS
  MOV  ES, AX         ; store the current CS in ES
GoToIt:
  JMP  DWORD PTR ES:[DI+BX]


RAM_CODE ENDS

  END
